function buffer_plot = trigger_shift(last_buffer)
global IMDEA_generator IMDEA_sound_card IMDEA_oscilloscope

switch IMDEA_oscilloscope.trigger

    case 1 % off
        
        N_trigger_shift = 0;
    
    case 2 % inner
    
        N_trigger_shift = round(IMDEA_generator.phase(end)/(2*pi*IMDEA_generator.f)*IMDEA_sound_card.fs);
        
    case 3 % outer
        n = IMDEA_oscilloscope.trigger_channel;
        buffer_max = max(last_buffer(:,n));
        N_trigger_shift = IMDEA_sound_card.BufferSize - find(last_buffer(:,n)>0.9*buffer_max, 1, 'last') + 1;
        
end

buffer_plot = [IMDEA_oscilloscope.last_buffer(end-N_trigger_shift+1:end,:); IMDEA_oscilloscope.buffer(1:end-N_trigger_shift,:)];